/*
 * Copyright (C) Jan 2006 Mellanox Technologies Ltd. All rights reserved.
 *
 * This software is available to you under a choice of one of two
 * licenses.  You may choose to be licensed under the terms of the GNU
 * General Public License (GPL) Version 2, available from the file
 * COPYING in the main directory of this source tree, or the
 * OpenIB.org BSD license below:
 *
 *     Redistribution and use in source and binary forms, with or
 *     without modification, are permitted provided that the following
 *     conditions are met:
 *
 *      - Redistributions of source code must retain the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer.
 *
 *      - Redistributions in binary form must reproduce the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer in the documentation and/or other materials
 *        provided with the distribution.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 *  ParamList.h - Paramater definition class
 *
 *  Version: $Id: ParamList.h 2752 2006-01-19 14:40:17Z mst $
 *
 */

#ifndef PARAMDEF_H
#define PARAMDEF_H

#include <stdio.h>
#include <stdarg.h>
#include <expat.h>

#include <map>
#include <list>
#include <string>

#include "compatibility.h"
#include "utils.h"

#define NOT_ALLOWED_IN_PARAM_NAME "\t\n\r=#;" //!!! orenk: I removed space (' '). Is it ok ? !!!
#define PSID_PARAM_NAME           "PSID.PSID"
#define EXP_ROM_EN_PARAM_NAME_OLD "ADAPTER.Expansion ROM Enable"
#define EXP_ROM_EN_PARAM_NAME     "ADAPTER.exp_rom_en"

class Perl;
class Param;
class Group;
class Enum;
class MultiFile;
class ParamList : public ErrMsg
{
public:
    ParamList();
    ~ParamList();

    bool       readFile(const MultiFile& mfile, const char *pfname=0);
    bool       readBrdFile(const char * fname);
    bool       writeConfFile(const char *fname, bool delta = false);
    void       clear_def_source();
    const bool initialized() { return !_fname.empty(); }
    const char *fname()      { return _fname.c_str();  };
    bool       exists(const char* pname); 

    // !!! PSID param does not appear in old fw revisions. - this is a way to add it during run. 
    bool       add_psid(std::string name ,std::string type, std::string addr);

    // set exp rom enable parameter if expansion rom is given.
    bool       enableExpRom();


    std::map<std::string, Group*> grmap;
    std::list<Group*>             grlist;
    std::map<std::string, Param*> refparams; // Params which have refname attribute (tavor backward compatibility)
    std::map<std::string, Param*> params;    // Params in GROUP.PARAM form
    std::map<std::string, Enum*>  enums;     // Enums values

    void        setPerl(const std::string& expr);
    std::string getPerl() { return _perl; }
    bool        finalize_init();
    bool        finalize_eval();

    bool        _print_refnames;

private:

    bool       writeIniFile(FILE* fp, bool delta = false);
    bool       writeBrdFile(FILE* fp);

    // XML callbacks
    static void COMP_CDECL s_start_el(void *userData, const XML_Char *name,
                           const XML_Char **atts)
        { ((ParamList*)userData)->h_start_el(name, atts); }

    static void COMP_CDECL s_end_el(void *userData, const XML_Char *name)
        { ((ParamList*)userData)->h_end_el(name); }

    static void COMP_CDECL s_chars(void *userData, const XML_Char *s, int len)
        { ((ParamList*)userData)->h_chars(s, len); }

    // Real methods called on callbacks
    void h_start_el(const XML_Char *name, const XML_Char **atts);
    void h_end_el(const XML_Char *name);
    void h_start_doc();
    void h_end_doc();
    void h_chars(const XML_Char *s, int len);

public:
    // Element specific handlers
    void start_source(std::map<std::string,std::string>& atts);
    void start_inipref(std::map<std::string,std::string>& atts);
    void start_set_default_prop(std::map<std::string,std::string>& atts);
    void start_perl(std::map<std::string,std::string>& atts);
    void start_enum(std::map<std::string,std::string>& atts);
    void start_group(std::map<std::string,std::string>& atts);
    void start_param(std::map<std::string,std::string>& atts);
    void end_source();
    void end_inipref();
    void end_set_default_prop();
    void end_perl();
    void end_enum();
    void end_group();
    void end_param();

private:
    void _debug(const char *tag);
    void _debuga(const char *tag, std::map<std::string,std::string>& atts);
    bool name_is_valid(const std::string& name);

    // Misc methods
    static void convDescription(std::string &txt,
                                const bool rem_all_traling_newlines = false);
    
    std::string convIni2PerlComments(const std::string& descr);

    bool extractBool(std::map<std::string,std::string>& atts,
                     const char *aname, bool& value);
    bool extractInt(std::map<std::string,std::string>& atts,
                    const char *aname, int32_t& value);
    bool extractUns(std::map<std::string,std::string>& atts,
                    const char *aname, u_int32_t& value);
    bool extractInt64(std::map<std::string,std::string>& atts,
                      const char *aname, int64_t& value);
    bool extractUns64(std::map<std::string,std::string>& atts,
                      const char *aname, u_int64_t& value);
    bool extractVers(const char *pname, const std::string& sver, int& ver);
    void replaceVersion(std::string& txt);
    void replaceDate(std::string& txt);


    // Data
    std::string _fname;
    MultiFile   *_mfile;
    int          _line;
    Group       *_cur_group;
    Param       *_cur_param;
    Enum        *_cur_enum;
    std::string _cur_txt;
    std::string _ini_pref;
    bool        _first_par;
    XML_Char    **_char_atts;
    bool        _parser_debug;
    std::string _perl;             // Perl fragment
    std::string _perl_replacement; // Perl replacement
    Perl        *_Perl;            // The Perl low-level class
};

#endif
